<?php

require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/functions.php';

// error_reporting(E_ALL);
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$data = json_decode(file_get_contents('php://input'), true);

$host = 'localhost';
$db = 'chatbot_booking_db';
$user = 'root';
$pass = '';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get ID from URL
$id = isset($data['client_id']) ? intval($data['client_id']) : 0;

$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

$user = $result->fetch_assoc();
$stmt->close();
$conn->close();


if(isset($user)){
    
    global $company_name, $comapny_code, $company_doc, $company_token, $company_get_token;

    $company_name = $user['company_name'] ?? 'Mukesoft';
    $comapny_code = $user['comapny_code'] ?? 'MUKE';
    $company_doc = $user['company_doc'] ?? 'mukesoft user manual.txt';
    $company_token = $user['company_token'] ?? 'token.json';
    $company_get_token = 'get-token.php';
    $creds = $user['credentials'] ?? '';


    // --- Chat Transcript Email Logic ---//
    if (isset($data['action']) && $data['action'] === 'end_chat' && isset($data['transcript'])) {
        $dateToday = date('F j, Y'); // e.g., May 21, 2025
        $transcript = $data['transcript'];
        // Build HTML table for chat transcript
        $htmlBody = '
        <div style="font-family:Arial,sans-serif;background:#f4f8fb;padding:32px 0;">
        <div style="max-width:600px;margin:0 auto;background:#fff;border-radius:14px;overflow:hidden;box-shadow:0 4px 18px rgba(0,0,0,0.07);border:1px solid #e0e0e0;">
            <div style="background:linear-gradient(90deg,#1976d2 60%,#42a5f5 100%);color:#fff;padding:24px 32px;display:flex;align-items:center;justify-content:space-between;">
            <span style="font-size:22px;font-weight:700;letter-spacing:0.5px;">'. $company_name .' Chat Transcript - ' . $dateToday . '</span>
            </div>
            <table style="width:100%;border-collapse:collapse;font-size:15px;margin:0;">
            <thead>
                <tr style="background:#f5f7fa;">
                <th style="padding:16px 14px;border-bottom:2px solid #e3e3e3;text-align:left;">Sender</th>
                <th style="padding:16px 14px;border-bottom:2px solid #e3e3e3;text-align:left;">Message</th>
                </tr>
            </thead>
            <tbody">';
        foreach ($transcript as $msg) {
            $sender = htmlspecialchars(ucfirst($msg['sender']));
            $message =$msg['message'];
            // Sender initials avatar
            $initial = strtoupper(substr($sender,0,1));
            $avatar = '<span style="display:inline-block;width:32px;height:32px;background:#1976d2;color:#fff;border-radius:50%;text-align:center;line-height:32px;font-weight:bold;margin-right:10px;">'.$initial.'</span>';
            $htmlBody .= "<tr>
            <td style='padding:14px 12px;border-bottom:1px solid #f0f0f0;font-weight:600;color:#1976d2;vertical-align:top;'>
                $avatar $sender
            </td>
            <td style='padding:14px 12px;border-bottom:1px solid #f0f0f0;vertical-align:top;'>$message</td>
            </tr>";
        }
        $htmlBody .= '
            </tbody>
            </table>
            <div style="background:#f5f5f5;padding:16px 28px;text-align:center;color:#888;font-size:13px;border-top:1px solid #e0e0e0;">
            End of transcript &mdash; Thank you for chatting with '. $company_name .'!
            </div>
            <div style="padding:18px 32px;text-align:center;color:#b0b0b0;font-size:12px;">
            &copy; 2025 '. $company_name .'. All rights reserved.<br>
            <a href="mailto:support@apniamc.com" style="color:#1976d2;text-decoration:none;">Contact Support</a>
            </div>
        </div>
        </div>';

        // Build plain text fallback
        $plainBody = "$company_name Chat Transcript:\n\n";
        foreach ($transcript as $msg) {
            $plainBody .= strtoupper($msg['sender']) . ": " . $msg['message'] . "\n";
        }
        // custommailsend('pankaj@mukesoft.com', 'Apni AMC Chat Transcript - ' . $dateToday, $htmlBody, $plainBody);
        exit;
    }

    $question_old = $data['question'] ?? '';
    $question = correctSpelling($question_old);

    // echo $question;

    if (empty($question)) {
        echo json_encode(['error' => 'No question provided.']);
        exit;
    }
    $slot_page = $data['slot_page'] ?? '0';

    // Check for greeting/thanks and respond directly
    $greetingPatterns = [
        '/\bok\b/i',
        '/\bokay\b/i',
        '/\bthank you\b/i',
        '/\bthanks\b/i',
        '/\bthx\b/i',
        '/\bthankyou\b/i',
        '/\bgrateful\b/i',
        '/\bappreciate\b/i',
        '/\bcheers\b/i'
    ];
    foreach ($greetingPatterns as $pattern) {
        if (preg_match($pattern, $question)) {
            $greetMsg = 'Thank you! Should you need any more information or assistance, please feel free to get in touch at your convenience.';
            echo json_encode(['answer' => $greetMsg]);
            exit;
        }
    }

    // Prepare the content text (e.g., from manual + question)
    $manualText = file_exists($company_doc) ? file_get_contents($company_doc) : '';

    function getGoogleClient($company_name,$company_token,$creds,$id ) {
        $client = new Google_Client();
        $client->setApplicationName(''. $company_name .' Chatbot Demo Booking');
        $client->setScopes(Google_Service_Calendar::CALENDAR);
        if($creds != '') {
            $decodedCreds = json_decode($creds, true);
            if (json_last_error() === JSON_ERROR_NONE) {
                $client->setAuthConfig($decodedCreds);
            } else {
                die("Invalid JSON format for credentials.");
            }
        }
        else {
            $client->setAuthConfig(__DIR__ . '/credentials.json'); // Use default credentials if not provided
        }
        $client->setAccessType('offline');
        $client->setPrompt('select_account consent');
        $client->setState("clientId_$id ");

        $tokenPath = __DIR__ . '/uploads/' . $company_token;
        if (file_exists($tokenPath)) {
            $accessToken = json_decode(file_get_contents($tokenPath), true);
            $client->setAccessToken($accessToken);
        }
        if ($client->isAccessTokenExpired()) {
            if ($client->getRefreshToken()) {
                $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            } else {
                $authUrl = $client->createAuthUrl();
                echo json_encode(['answer' => "To enable demo booking, authorize this app: $authUrl"]);
                exit;
            }
            file_put_contents($tokenPath, json_encode($client->getAccessToken()));
        }
        return $client;
    }
    function bookDemoSlot($calendarId, $slot, $clientName, $clientEmail, $company_name, $comapny_code, $company_doc, $company_token, $company_get_token, $creds,$id ) {
        $client = getGoogleClient($company_doc,$company_token,$creds,$id );
        $service = new Google_Service_Calendar($client);
        // $start = date('c', strtotime($slot));
        // $end = date('c', strtotime($slot) + 30*60);
        $dateTime = DateTime::createFromFormat('d/m/Y h:i A', $slot, new DateTimeZone('Asia/Kolkata'));
        if (!$dateTime) {
            throw new Exception("Invalid slot format: '$slot'. Expected format: Y-m-d h:i A (e.g., 2025-05-16 04:30 PM)");
        }
        $start = $dateTime->format('c');
        $end = $dateTime->modify('+30 minutes')->format('c');
        // Sanitize and validate email
        $clientEmail = trim($clientEmail);
        if (!filter_var($clientEmail, FILTER_VALIDATE_EMAIL)) {
            throw new Exception("Invalid attendee email address: $clientEmail");
        }
        $event = new Google_Service_Calendar_Event([
            'summary' => 'ApniAMC Demo Booking',
            'description' => "Demo booked by $clientName ($clientEmail) via chatbot.",
            'start' => ['dateTime' => $start, 'timeZone' => 'Asia/Kolkata'],
            'end' => ['dateTime' => $end, 'timeZone' => 'Asia/Kolkata'],
            'attendees' => [['email' => $clientEmail]],
            'conferenceData' => [
                'createRequest' => [
                    'requestId' => uniqid(),
                    'conferenceSolutionKey' => [
                        'type' => 'hangoutsMeet'
                    ]
                ]
            ]
        ]);
        try {
            $event = $service->events->insert($calendarId, $event, ['conferenceDataVersion' => 1]);
            $meetLink = '';
            if (isset($event->conferenceData) && isset($event->conferenceData->entryPoints)) {
                foreach ($event->conferenceData->entryPoints as $entryPoint) {
                    if ($entryPoint->entryPointType === 'video') {
                        $meetLink = $entryPoint->uri;
                        break;
                    }
                }
            } else if (method_exists($event, 'getHangoutLink')) {
                $meetLink = $event->getHangoutLink();
            }
            $calendarLink = $event->htmlLink;
            // --- EMAIL NOTIFICATION LOGIC HERE (PHPMailer SMTP) ---

            //   $body = "Hello $clientName,\n\nYour demo has been scheduled for: $slot";
            //   if ($meetLink) {
            //       $body .= "\nGoogle Meet link: $meetLink";
            //   }
            //   $body .= "\n\nThank you for booking with us!";

            //   custommailsend($clientEmail,'Your Demo is Scheduled for Apni AMC',$body,$body,$clientName);

            $body = "
                    <html>
                    <head>
                    </head>
                    <body style='font-family: Arial, sans-serif;
                        color: #333;'>
                    <div class='container' style=' padding: 20px;border: 1px solid #eee;border-radius: 10px;background-color: #f9f9f9;max-width: 600px;margin: auto;'>
                        <div class='header' style=' font-size: 20px;margin-bottom: 20px;'>Hello $clientName,</div>
                        <div class='details' style='font-size: 16px;line-height: 1.5;'>
                        Your demo has been successfully scheduled for: <strong>$slot</strong><br><br>";

                    if ($meetLink) {
                        $body .= "Google Meet Link: <a class='link' style='color: #1a73e8;text-decoration: none;' href='$meetLink'>$meetLink</a><br><br>";
                    }

                    $body .= "
                        Thank you for booking with us!
                        </div>
                        <div class='footer' style='margin-top: 30px;font-size: 14px;color: #666;'>
                        — ". $company_name ." Team
                        </div>
                    </div>
                    </body>
                    </html>
                    ";

            // Use the HTML content in both plain text and HTML part (if sending multipart emails)
            // custommailsend($clientEmail, 'Your Demo is Scheduled for '. $company_name .'', $body, null, $clientName);

            // --- END EMAIL LOGIC ---
            return [
                'success' => 1,
                'calendarLink' => $calendarLink,
                'meetLink' => $meetLink
            ];
        } catch (Exception $e) {
            // Return a user-friendly error
            return [
                'calendarLink' => '',
                'meetLink' => '',
                'error' => "Error: Could not book the demo. Please check the email address and try again."
            ];
        }
    }
    function getCalendarEvents($calendarId = 'primary', $days = 14,$company_doc,$company_token,$creds,$id ) {
        $client = getGoogleClient($company_doc,$company_token,$creds,$id ); // Your existing method to authenticate
        $service = new Google_Service_Calendar($client);

        $timezone = new DateTimeZone('Asia/Kolkata');
        $now = new DateTime('now', $timezone);
        $maxDate = clone $now;
        $maxDate->modify("+$days days");

        $optParams = [
            'orderBy' => 'startTime',
            'singleEvents' => true,
            'timeMin' => $now->format(DateTime::RFC3339),
            'timeMax' => $maxDate->format(DateTime::RFC3339),
        ];

        $eventsResult = $service->events->listEvents($calendarId, $optParams);
        $events = [];

        foreach ($eventsResult->getItems() as $event) {
            $start = $event->start->dateTime ?? $event->start->date;
            $end = $event->end->dateTime ?? $event->end->date;

            if ($start && $end) {
                $events[] = [
                    'start' => $start,
                    'end' => $end,
                ];
            }
        }

        return $events;
    }


    function getAvailableTimeSlots($days = 14, $slotsPerPage = 15, $page = 0, $specificDate = null,$company_name, $comapny_code, $company_doc, $company_token, $company_get_token,$creds,$id ) {
        $timezone = new DateTimeZone('Asia/Kolkata');
        $slots = [];

        if ($specificDate) {
            $current = new DateTime($specificDate . ' 10:00', $timezone);
            $end = new DateTime($specificDate . ' 18:00', $timezone);
        } else {
            $now = new DateTime('now', $timezone);
            $current = clone $now;
            $current->setTime((int)$now->format('H'), ceil($now->format('i')/30)*30, 0);
            if ($current < $now) {
                $current->modify('+30 minutes');
            }
            $end = clone $now;
            $end->modify("+$days days");
        }

        // while ($current < $end) {
        //     $hour = (int)$current->format('H');
        //     if ($hour >= 10 && $hour < 18) {
        //         $slots[] = $current->format('d/m/Y h:i A');
        //     }

        //     $current->modify('+30 minutes');

        //     if (!$specificDate && $current->format('H') >= 18) {
        //         $current->setTime(10, 0, 0);
        //         $current->modify('+1 day');
        //     }
        // }
        $events = getCalendarEvents('primary', $days,$company_doc,$company_token,$creds,$id );
        while ($current < $end) {
            $hour = (int)$current->format('H');

            if ($hour >= 10 && $hour < 18) {
                $slotStart = clone $current;
                $slotEnd = clone $current;
                $slotEnd->modify('+30 minutes');

                $conflict = false;
                foreach ($events as $event) {
                    $eventStart = new DateTime($event['start'], $timezone);
                    $eventEnd = new DateTime($event['end'], $timezone);

                    // Check for overlap
                    if ($slotStart < $eventEnd && $slotEnd > $eventStart) {
                        $conflict = true;
                        break;
                    }
                }

                if (!$conflict) {
                    $slots[] = $current->format('d/m/Y h:i A');
                }
            }

            $current->modify('+30 minutes');

            if (!$specificDate && $current->format('H') >= 18) {
                $current->setTime(10, 0, 0);
                $current->modify('+1 day');
            }
        }


        
        $totalSlots = count($slots);
        $allSlots = $slots;
        $slots = array_slice($slots, $page * $slotsPerPage, $slotsPerPage);
        
        return [
            'slots' => $slots,
            'total' => $totalSlots,
            'page' => $page,
            'has_more' => ($totalSlots > (($page + 1) * $slotsPerPage)),
            'all_slots' => $allSlots
        ];
    }

    function extractDateFromText($text) {
        $text = strtolower(trim($text));
        $timezone = new DateTimeZone('Asia/Kolkata');
        
        // Handle 'today' and 'tomorrow' first
        if (preg_match('/\b(today|tonight|now)\b/i', $text)) {
            return (new DateTime('today', $timezone))->format('Y-m-d');
        }
        
        if (preg_match('/\b(tomorrow|tmrw|tmr|next day|following day)\b/i', $text)) {
            return (new DateTime('tomorrow', $timezone))->format('Y-m-d');
        }

        // Pattern 1: 28th May, 28 May
        if (preg_match('/\b(\d{1,2})(st|nd|rd|th)?\s*(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)[a-z]*\b/i', $text, $matches)) {
            $day = $matches[1];
            $month = $matches[3];
            $dateString = "$day $month";
            try {
                $dt = new DateTime($dateString, new DateTimeZone('Asia/Kolkata'));
                return $dt->format('Y-m-d');
            } catch (Exception $e) {
                return null;
            }
        }

        // Pattern 2: May 28
        if (preg_match('/\b(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)[a-z]*\s*(\d{1,2})(st|nd|rd|th)?\b/i', $text, $matches)) {
            $month = $matches[1];
            $day = $matches[2];
            $dateString = "$day $month";
            try {
                $dt = new DateTime($dateString, new DateTimeZone('Asia/Kolkata'));
                return $dt->format('Y-m-d');
            } catch (Exception $e) {
                return null;
            }
        }

        // Pattern 3: 28/05 or 28-05[-2025]
        if (preg_match('/\b(\d{1,2})[\/\-](\d{1,2})([\/\-](\d{4}))?\b/', $text, $matches)) {
            $day = str_pad($matches[1], 2, "0", STR_PAD_LEFT);
            $month = str_pad($matches[2], 2, "0", STR_PAD_LEFT);
            $year = isset($matches[4]) ? $matches[4] : date('Y');

            $dateString = "$year-$month-$day";
            try {
                $dt = new DateTime($dateString, new DateTimeZone('Asia/Kolkata'));
                return $dt->format('Y-m-d');
            } catch (Exception $e) {
                return null;
            }
        }

        return null;
    }

    // Constants for slot management
    define('SLOTS_PER_PAGE', 4); // Show 4 slots at a time
    define('MAX_DAYS_IN_FUTURE', 14); // Maximum days to show slots for

    // Handle custom time slot requests with natural language processing
    $keywords = ['book', 'schedule', 'want', 'arrange', 'need', 'require', 'organize', 'plan', 'set', 'prefer', 'suggest'];
    $hasKeyword = false;

    // Check if any scheduling keyword is in the question
    foreach ($keywords as $keyword) {
        if (stripos($question, $keyword) !== false) {
            $hasKeyword = true;
            break;
        }
    }

    // Show available slots if user requests demo or next slots
    if (preg_match('/(book|schedule|want|arrange|need|require|organize|plan|set|line up|organize).*demo/i', $question) ||
        preg_match('/(next|more|another|available).*slot/i', $question) || 
        (isset($data['show_slots']) && $data['show_slots'])) {
        
        // Get the current page and date from the request
        $input = json_decode(file_get_contents('php://input'), true);
        $slot_page = isset($input['slot_page']) ? intval($input['slot_page']) : 0;
        
        // Handle slot pagination
        if (preg_match('/(book|schedule|want|arrange|need|require|organize|plan|set|line up|organize).*demo/i', $question) || 
            preg_match('/show.*slots|available.*times?/i', $question)) {
            $slot_page = 0; // Reset to first page for new requests
        } 
        
        // Extract date from the question or use the one from the request
        $date = extractDateFromText($question);
        if (!$date && isset($input['selected_date'])) {
            $date = $input['selected_date'];
        }
        
        // For next slot requests, show more days but still 4 slots per page
        $daysToShow = ($slot_page === 0) ? 3 : 14;
        // $date = extractDateFromText($question);

        $timezone = new DateTimeZone('Asia/Kolkata');
        // Check if the given date is in the past
        $now = new DateTime('now', $timezone);
        $givenDate = new DateTime($date, $timezone);
        $givenDate->setTime(0, 0, 0);
        $today = clone $now;
        $today->setTime(0, 0, 0);
        
        if ($givenDate < $today) {
            echo json_encode(['answer' => 'The selected date has already passed. Please choose a future date.']);
            exit;
        
        }
        
        $result = getAvailableTimeSlots($daysToShow, SLOTS_PER_PAGE, $slot_page, $date,$company_name, $comapny_code, $company_doc, $company_token, $company_get_token,$creds,$id );
        $slots = $result['slots'];
        $totalSlots = $result['total'];
        
        if (empty($slots)) {
            echo json_encode(['answer' => 'Sorry, there are no more available demo slots. Please try again later or contact our support team at support@apniamc.com.']);
            exit;
        }
        $slotList = '';
        foreach ($slots as $i => $slot) {
            $slotNumber = ($i + 1 + $slot_page * SLOTS_PER_PAGE);
            $slotTime = $slot; // Assuming $slot is already formatted as a string
            
            // Add alternating row colors for better readability
            $rowBg = ($i % 2 === 0) ? '#ffffff' : '#f8f9fa';
            
            $slotList .= "
                <li><strong>$slotNumber: </strong>$slotTime</li>";
        }
        $date_text = '';
        // Handle 'today' and 'tomorrow' first
        if (preg_match('/\b(today|tonight|now)\b/i', $question, $matches)) {
            $date_text = $matches[1];
        }
        
        if (preg_match('/\b(tomorrow|tmrw|tmr|next day|following day)\b/i', $question, $matches)) {
            $date_text = $matches[1];
        }

        // Pattern 1: 28th May, 28 May
        if (preg_match('/\b(\d{1,2})(st|nd|rd|th)?\s*(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)[a-z]*\b/i', $question, $matches)) {
            $day = $matches[1];
            $month = $matches[3];
            $date_text = "$day $month";
        }
        // Pattern 3: 28/05 or 28-05[-2025]
        if (preg_match('/\b(\d{1,2})[\/\-](\d{1,2})([\/\-](\d{4}))?\b/', $question, $matches)) {
            $day = str_pad($matches[1], 2, "0", STR_PAD_LEFT);
            $month = str_pad($matches[2], 2, "0", STR_PAD_LEFT);
            $year = isset($matches[4]) ? $matches[4] : date('Y');

            $date_text = "$year-$month-$day";
        }    
        // Pattern 2: May 28
        if (preg_match('/\b(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)[a-z]*\s*(\d{1,2})(st|nd|rd|th)?\b/i', $question, $matches)) {
            $month = $matches[1];
            $day = $matches[2];
            $date_text = "$day $month";
        }
        $reply = "<div style='max-width:480px; border-radius:12px; font-family:Segoe UI, Arial, sans-serif; font-size:16px; color:#2c3e50;'>
            <div style='font-size:22px; font-weight:600; margin-bottom:16px; color:#007BFF;'>🎯 Available Demo Slots</div>
            
            <div style='font-size:15px; margin-bottom:18px;'>Below are the available demo slots:</div>
            
            <ul style='padding-left:0; margin:0 0 24px 0; list-style:none; margin-bottom:10px; padding:8px 12px; background:#fff; border-radius:6px; box-shadow:0 1px 3px rgba(0,0,0,0.05);'>
                $slotList
            </ul>
            
            <div style='font-size:15px; margin-bottom:12px; background:#dff0d8; padding:12px 16px; border-left:4px solid #28a745; border-radius:8px;'>
                ✅ <strong>Reply with the <u>slot number</u></strong> you’d like to book.
            </div>
            
            <div style='font-size:15px; background:#fff3cd; padding:12px 16px; border-left:4px solid #ffc107; border-radius:8px;'>
                🔄 <strong>If none of these slots work for you</strong>, reply with <span style='color:#e83e8c; font-weight:bold;'>Next slot" . ((isset($date) && $date) ? " for " . $date_text : "") . "</span> to receive more options.
            </div>
        </div>";
        
        
        // Store the slots in the response for client-side tracking
        echo json_encode([
            'answer' => $reply,
            'slot_page' => $slot_page,
            'has_more' => $result['has_more'],
            'slots' => $slots, // Include the actual slot data
            'slot_data' => $result['all_slots'] // Add clean array of just the slot times
        ]);
        exit;
    }

    // Step 2: If user replies with a slot number, ask for name and email
    if (preg_match('/^(\d{1,4})$/', trim($question), $matches)) {
        // Get the same slots that were shown to the user
        $slot_page = 0;
        $daysToShow = 14; // Show more days to ensure we find the slot

        
        $date = extractDateFromText($question);
        if(isset($data['slot_data']) && $data['slot_data']){
            // echo $data['slot_data'];exit;
                $result = [
                    'slots' => explode(',', $data['slot_data']),
                    'has_more' => false,
                    'slot_page' => 0
                ];
        }else{
            // echo "out";die;
            $result = getAvailableTimeSlots($daysToShow, 100, 0, $date,$company_name, $comapny_code, $company_doc, $company_token, $company_get_token,$creds,$id ); // Get all available slots
        }
        
        $allSlots = $result['slots'];
        
        $slotNum = intval($matches[1]);
        if ($slotNum < 1 || $slotNum > count($allSlots)) {
            echo json_encode(['answer' => 'Invalid slot number. Please try again.']);
            exit;
        }
        
        $selectedSlot = $allSlots[$slotNum - 1];
        
        echo json_encode([
            'answer' => "Great! To proceed, please provide your details in the format below:<br>
                <div style='background:#f9f9f9; border:1px solid #e0e0e0; border-radius:8px; padding:16px; margin:12px 0; font-size:16px;'>
                <span style='font-weight:bold;'>Name:</span> <span style='padding:2px 6px; border-radius:4px;'>[Your Name]</span><br>
                <span style='font-weight:bold;'>Email:</span> <span style='padding:2px 6px; border-radius:4px;'>[your@email.com]</span><br>
                <span style='font-weight:bold;'>Slot:</span> <span style='padding:2px 6px; border-radius:4px; background:#e3f2fd;'>$selectedSlot</span>
                </div>
                <span style='font-weight:bold;'>Please copy-paste the Slot exactly as shown (including minutes and AM/PM) for successful booking.</span><br>"
        ]);
        exit;
    }

    // Step 3: If user provides name and email, book the slot
    if (preg_match('/name\s*:\s*(.*?)\s*email\s*:\s*([^\s]+@[^\s]+)\s*/is', $question, $matches)) {
        // Handle slot confirmation and booking
        $normalizedQuestion = preg_replace('/\s+/', ' ', $question);
        if (preg_match('/slot\s*:\s*(\d{2}\/\d{2}\/\d{4}\s+\d{1,2}:\d{2}\s+[APMapm]{2})/i', $normalizedQuestion, $slotMatch)) {
            $slotTime = trim($slotMatch[1]);
            if (preg_match('/name\s*:\s*(.*?)\s*email\s*:\s*([^\s]+@[^\s]+)\s*/is', $question, $matches)) {
                
                $name = trim($matches[1]);
                $email = trim($matches[2]);
                
                // Basic email validation
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    echo $email;
                    echo json_encode(['answer' => 'Please enter a valid email address.']);
                    exit;
                }
                
                // Book the slot
                try {
                    $bookingResult = bookDemoSlot('primary', $slotTime, $name, $email, $company_name, $comapny_code, $company_doc, $company_token, $company_get_token,$creds,$id );

                    if ($bookingResult['success']) {                        
                        echo json_encode([
                            'answer' => "✅ <b>Booking Confirmed!</b><br><br>" .
                                        "Thank you, $name! Your demo has been scheduled for $slotTime.<br><br>" .
                                        "A confirmation has been sent to $email. We're looking forward to meeting you!"
                        ]);
                    } else {
                        $errorMsg = $bookingResult['error'] ?? 'Sorry, there was an error booking your slot.';
                        echo json_encode(['answer' => $errorMsg . " Please try again or contact support."]);
                    }
                    exit;
                } catch (Exception $e) {
                    error_log("Booking error: " . $e->getMessage());
                    echo json_encode(['answer' => "An error occurred while processing your booking. Please try again later."]);
                    exit;
                }
            } else {
                // Missing name or email
                echo json_encode(['answer' => 'Please provide both your name and email to confirm the booking.']);
                exit;
            }
        } else {
            // Invalid slot format
            echo json_encode(['answer' => "Could not recognize the slot you entered. Please copy-paste the slot exactly as shown, including minutes and AM/PM, e.g. <b>21/05/2025 04:30 PM</b>."]);
            exit;
        }
    }

    // Greeting detection
    // $greetings = ['hi', 'hello', 'hey', 'good morning', 'good afternoon', 'good evening', 'greetings','that\'s great..
    // ','yes','great!'];
    // if (in_array(strtolower(trim($question)), $greetings)) {
    //     echo json_encode(['answer' => 'Hi! How can I help you with Apni AMC?']);
    //     exit;
    // }

    $checkgreeting = checkgreetings($question);

    if($checkgreeting == 'yes')
    {
        echo json_encode(['answer' => 'How can I help you with '. $company_name .'?']);
        exit;
    }

    $promptText = "$company_name Project:\n$manualText\n\nQuestion: $question\n\nPlease answer briefly and concisely in 1-2 sentences, focusing only on the most important information.";

    // Gemini API call setup
    $apiKey = 'AIzaSyBLW4S5bdXLXaxesf0vh6SiakDfhxkvuu4'; // Replace with your Gemini API key
    // $apiKey = 'AIzaSyDLZrg-5W1IvamRkqClAXgaQO2z-kvHUy4'; // Replace with your Gemini API key

    $endpoint = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

    $postData = [
        'contents' => [
            [
                'role' => 'user',
                'parts' => [
                    ['text' => $promptText]
                ]
            ]
        ]
    ];

    $ch = curl_init($endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Handle response
    if ($httpCode >= 400) {
        echo json_encode(['error' => "API error (HTTP $httpCode).", 'response' => $response]);
        exit;
    }

    $data = json_decode($response, true);
    $answer = $data['candidates'][0]['content']['parts'][0]['text'] ?? null;

    if ($answer) {

        // Make answer short and meaningful: keep only the first sentence or up to 150 chars
        $shortAnswer = preg_split('/([.!?])/', $answer, 2, PREG_SPLIT_DELIM_CAPTURE);
        if (count($shortAnswer) > 1) {
            $answer = trim($shortAnswer[0] . $shortAnswer[1]);
        } else {
            $answer = mb_substr($answer, 0, 150) . (mb_strlen($answer) > 150 ? '...' : '');
        }

        // Fallback if answer mentions missing documentation
        $missingDocPatterns = [
            '/not (in|into) (the )?document/i',
            '/not specified (in|on|by) (the )?(manual|document)/i',
            '/not mentioned (in|on|by) (the )?(manual|document)/i',
            '/not covered (in|on|by) (the )?(manual|document)/i',
            '/not detailed (in|on|by) (the )?(manual|document)/i',
            '/manual doesn\'t (cover|specify|mention)/i',
            '/document doesn\'t (cover|specify|mention)/i',
            '/no step(-| )?by(-| )?step (instruction|guide)/i',
            '/details (are )?(missing|not provided|not available)/i',
            '/not available in the manual/i',
            '/not available in document/i',
            '/not present in (the )?(manual|document)/i',
            '/not found in (the )?(manual|document)/i',
            '/not included in (the )?(manual|document)/i',
            '/not listed in (the )?(manual|document)/i',
            '/no information about.*in (the )?(manual|document)/i',
            '/there is no information about.*in (the )?(manual|document)/i',
            '/there is no information about/i',
            '/there is no .* in (the )?(manual|document)/i',
            '/no information about/i',
            '/not found in (the )?document/i',
            '/not available in (the )?document/i',
            '/not present in (the )?document/i',
            '/not included in (the )?document/i',
            '/not listed in (the )?document/i',
            '/not covered in (the )?document/i',
            '/not described in (the )?document/i',
            '/AMC documentation doesn\'t detail/i',
            '/The provided document doesn\'t detail/i',
            '/documentation doesn\'t detail/i',
            '/provided doesn\'t/i',
            '/provided doesn\'t specify/i',
            '/provided text doesn\'t detail/i',
            '/not available in the provided text/i',
            '/not available in the provided document/i',
            '/The provided text doesn\'t specify/i',
            '/provided text/i',
            '/provided document/i',
        ];
        foreach ($missingDocPatterns as $pattern) {
            if (preg_match($pattern, $answer)) {
                $answer = 'Kindly reach out to our support team at pankaj@mukesoft.com for any further details or assistance.';
                break;
            }
        }
        echo json_encode(['answer' => $answer]);
    } else {
        echo json_encode(['error' => 'No valid answer returned.', 'raw_response' => $data]);
    }
}