<?php

require_once __DIR__ . '/vendor/autoload.php';

// DB connection
$host = 'localhost';
$db = 'chatbot_booking_db';
$user = 'root';
$pass = '';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$success = '';
$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $company_name = $_POST['company_name'];
    $comapny_code = $_POST['comapny_code'];
    $company_mail = $_POST['company_mail'];

    // Upload files
    $uploadDir = "uploads/";
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // Sanitize company code to be safe for filenames
    $company_code_safe = preg_replace('/[^A-Za-z0-9_\-]/', '', $comapny_code);

    // Get file extensions
    $docExt = pathinfo($_FILES['company_doc']['name'], PATHINFO_EXTENSION);

    // Rename files with company_code prefix
    $company_doc = $company_code_safe . '_doc.' . $docExt;
    $company_token = $company_code_safe . '_token.json';

    $docPath = $uploadDir . $company_doc;
    $tokenPath = $uploadDir . $company_token;
    // Move uploaded files
    if (move_uploaded_file($_FILES['company_doc']['tmp_name'], $docPath)) {
        // Save file names into database
        $sql = "INSERT INTO users (company_name, comapny_code, company_doc, company_token, company_mail)
                VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssss", $company_name, $comapny_code, $company_doc, $company_token, $company_mail);
        // Get auto-increment ID of inserted row

        if ($stmt->execute()) {
            $success = "Company registered and files uploaded!";
        } else {
            $error = "DB Error: " . $stmt->error;
        }
        $company_id = $stmt->insert_id;
        $stmt->close();

        $authUrl = generateGoogleAuthUrl($company_name,$company_token, $company_id);
        header("Location: $authUrl");
    } else {
        $error = "Error uploading files.";
    }

}

$conn->close();
function generateGoogleAuthUrl($company_name,$company_token,$id ) {
    $client = new Google_Client();
    $client->setApplicationName(''. $company_name .' Chatbot Demo Booking');
    $client->setScopes(Google_Service_Calendar::CALENDAR);
    $client->setAuthConfig(__DIR__ . '/credentials.json'); // Use default credentials if not provided
    $client->setAccessType('offline');
    $client->setPrompt('select_account consent');
    $client->setState("clientId_$id ");

    $tokenPath = __DIR__ . '/uploads/' . $company_token;
   

    if (file_exists($tokenPath)) {
        $accessToken = json_decode(file_get_contents($tokenPath), true);
        $client->setAccessToken($accessToken);
    }
    if ($client->isAccessTokenExpired()) {
        if ($client->getRefreshToken()) {
            $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
        } else {
            $authUrl = $client->createAuthUrl();
            echo $authUrl;
            exit;
        }
        file_put_contents($tokenPath, json_encode($client->getAccessToken()));
    }
    return $client;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Register Company</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="card shadow-lg">
        <div class="card-header bg-primary text-white">
            <h4>Register Company</h4>
        </div>
        <div class="card-body">
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
            <?php elseif ($error): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
            <?php endif; ?>

            <form method="POST" enctype="multipart/form-data">
                <div class="mb-3">
                    <label class="form-label">Company Name</label>
                    <input type="text" name="company_name" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Company Code</label>
                    <input type="text" name="comapny_code" class="form-control" required>
                </div>
                 <div class="mb-3">
                    <label class="form-label">Company Mail</label>
                    <input type="text" name="company_mail" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Company Doc</label>
                    <input type="file" name="company_doc" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-success">Submit</button>
            </form>
        </div>
    </div>
</div>
</body>
</html>
