<?php
require_once __DIR__ . '/vendor/autoload.php';

$client = new Google_Client();
$client->setApplicationName('ApniAMC Chatbot Demo Booking');
$client->setScopes(Google_Service_Calendar::CALENDAR);
$client->setAuthConfig(__DIR__ . '/credentials.json');
$client->setAccessType('offline');
$client->setPrompt('select_account consent');
$client->setRedirectUri('http://localhost/Chatbot/get-token.php');

$state = isset($_GET['state']) ? $_GET['state'] : '';
if (strpos($state, 'clientId_') === 0) {
    $client_id = str_replace('clientId_', '', $state);
}


if(!$client_id) {
    exit("Client ID is required to proceed.");
}else{
    
    $host = 'localhost';
    $db = 'chatbot_booking_db';
    $user = 'root';
    $pass = '';

    $conn = new mysqli($host, $user, $pass, $db);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Get ID from URL
    $id = $client_id ?? 1; // Default to 1 if not provided
    $sql = "SELECT * FROM users WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
    $conn->close();

    $token_file = $user['comapny_code']."_token.json" ?? "token.json"; // Default to 1 if not provided

    if (!isset($_GET['code'])) {
        $authUrl = $client->createAuthUrl();
        echo "Open the following link in your browser and authorize the app:<br>";
        echo "<a href='$authUrl' target='_blank'>$authUrl</a><br>";
        echo "After authorization, you will be redirected back to this page automatically.";
    } else {
        $accessToken = $client->fetchAccessTokenWithAuthCode($_GET['code']);
        if (isset($accessToken['error'])) {
            echo "<b>Google OAuth Error:</b><br>";
            echo htmlspecialchars(json_encode($accessToken, JSON_PRETTY_PRINT));
            exit("<br><br>Failed to fetch access token. Please check the error above.\n");
        }
        file_put_contents(__DIR__ . '/uploads/'.$token_file.'', json_encode($accessToken));
        echo "Token saved to token.json. You can now use the chatbot to book demos!";
    }

}
