<?php
require_once __DIR__ . '/vendor/autoload.php';

$client = new Google_Client();
$client->setApplicationName('ApniAMC Chatbot Demo Booking');
$client->setScopes(Google_Service_Calendar::CALENDAR);
$client->setAuthConfig(__DIR__ . '/credentials.json');
$client->setAccessType('offline');
$client->setPrompt('select_account consent');
$client->setRedirectUri('http://localhost/Chatbot/get-token.php');

if (!isset($_GET['code'])) {
    $authUrl = $client->createAuthUrl();
    echo "Open the following link in your browser and authorize the app:<br>";
    echo "<a href='$authUrl' target='_blank'>$authUrl</a><br>";
    echo "After authorization, you will be redirected back to this page automatically.";
} else {
    $accessToken = $client->fetchAccessTokenWithAuthCode($_GET['code']);
    if (isset($accessToken['error'])) {
        echo "<b>Google OAuth Error:</b><br>";
        echo htmlspecialchars(json_encode($accessToken, JSON_PRETTY_PRINT));
        exit("<br><br>Failed to fetch access token. Please check the error above.\n");
    }
    file_put_contents(__DIR__ . '/token.json', json_encode($accessToken));
    echo "Token saved to token.json. You can now use the chatbot to book demos!";
}
